/*
 * BASIC by Phil Cockcroft
 */
/*
 * terminal specific configuration routines for 80386's
 */
#include "conf.h"
#include <termios.h>

static	struct	termios	oterm, nterm;

extern  int     ter_width;
extern  char    noedit;

static  int     got_mode;

extern	int	ch_erase, ch_kill, ch_eof;
extern	int	ch_rprnt, ch_werase, ch_lnext, ch_susp;

void
setu_term()
{
#ifdef	TIOCGWINSZ
	struct	winsize	wsiz;

	if(ioctl(0, TIOCGWINSZ, &wsiz) >= 0)
		ter_width = wsiz.ws_col;
#endif
	(void) ioctl(0, TCGETS, &oterm);

	nterm = oterm;
	nterm.c_lflag &= ~(ECHO|ECHOK|ECHONL|ICANON);
	nterm.c_lflag |= ISIG;
	nterm.c_oflag &= ~OPOST;
	nterm.c_iflag &= ~(IGNCR|INLCR|ICRNL);
	nterm.c_iflag |= ISTRIP;
	ch_erase = nterm.c_cc[VERASE];
	ch_kill = nterm.c_cc[VKILL];
	ch_eof = nterm.c_cc[VEOF];
	ch_rprnt = nterm.c_cc[VREPRINT];
	ch_werase = nterm.c_cc[VWERASE];
	ch_lnext = nterm.c_cc[VLNEXT];
	ch_susp = nterm.c_cc[VSUSP];
	nterm.c_cc[VSUSP] = 0;
#ifdef	VDSUSP
	nterm.c_cc[VDSUSP] = 0;
#endif
	nterm.c_cc[VMIN] = 1;
	nterm.c_cc[VTIME] = 0;
	
	if(ter_width <= 0)
		ter_width=DEFWIDTH;
	got_mode = 1;
}

void
set_term()
{
	if(noedit || !got_mode)
		return;

	(void) ioctl(0, TCSETSW, &nterm);
}

/*ARGSUSED*/
void
rset_term(type)
int	type;
{
	if(noedit || !got_mode)
		return;

	(void) ioctl(0, TCSETSW, &oterm);
}
