#
# which machine you want
#
MC = i386
VERSION = SCO

CC = gcc
GCC_FLAGS = -fomit-frame-pointer -fstrength-reduce -fcombine-regs
# CFLAGS = -D$(MC) -O -v -Xc -D$(VERSION)
CFLAGS = -D$(MC) -O -D$(VERSION) $(GCC_FLAGS)
# MOPTFLAGS = -Oactl
MOPTFLAGS = -O $(GCC_FLAGS)

CONF = $(MC)/conf.h
HDR = bas.h
H = $(HDR) $(CONF)

BAS = bas1.o bas2.o bas3.o bas4.o bas5.o bas6.o bas7.o bas8.o bas9.o
ASSIST = assist.o term.o

ALL = $(BAS) $(ASSIST)

basic:  $(ALL)
	$(CC) $(ALL) -lm -o basic

clean:
	rm -f *.o *.s term.c

bas3.o:
	$(CC) -c -D$(MC) $(MOPTFLAGS) -D$(VERSION) bas3.c

assist.o: $(HDR)
	$(CC) -c -D$(MC) $(MOPTFLAGS) -D$(VERSION) assist.c

term.o: $(MC)/term.c $(CONF)
	$(CC) $(CFLAGS) -c $(MC)/term.c

$(BAS): $H
