/*
 * BASIC by Phil Cockcroft
 */
/*
 * configuration file for Intel 80386 systems
 */

/*
 * standard constants of a Intel 80386 processor
 */
#ifndef	_BAS_CONF_H_
#define	_BAS_CONF_H_

#include <unistd.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>

#define	IEEEMATHS

typedef union	{
	struct {
		unsigned fraction_low: 32;
		unsigned bits     :20;
		unsigned exponent :11;
		unsigned sign     : 1;
	} nan_parts;
	double d;
} dnan;

#define IsPosNAN(X)  (((dnan *)&(X))->nan_parts.sign == 0)

#define NaN(X)  (((dnan *)&(X))->nan_parts.exponent == 0x7ff)

#define BLOCKSIZ 4096		/* size of disk blocks */

#undef	UNPORTABLE
#undef	NO_SCOMMS

#define	DEFWIDTH	80	/* line length */

#define	SIG_JMP

#endif
